@extends('layouts.admin')

@section('content')
    <!-- Page Header -->
    <div class="py-6 bg-[#F6F6F6] border-b border-[#CBB4B0]">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-3xl font-bold text-gray-900">Tambah Karyawan</h1>
                    <p class="text-gray-600 mt-1">Tambah karyawan baru ke sistem</p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.employees.index') }}" 
                       class="bg-[#8B8B8B] text-white px-4 py-2 rounded-none hover:bg-[#192D50] transition duration-150">
                        Kembali
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 bg-[#F6F6F6]">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-[#F6F6F6] overflow-hidden shadow-sm sm:rounded-none border border-[#CBB4B0]">
                <div class="p-6">
                    <form method="POST" action="{{ route('admin.employees.store') }}" class="space-y-6">
                        @csrf
                        
                        <!-- Company Selection -->
                        <div class="bg-[#F6F6F6] p-4 rounded-none mb-6 border border-[#CBB4B0]">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Pilih Perusahaan</h3>
                            
                            <div>
                                <label for="company_id" class="block text-sm font-medium text-gray-700 mb-2">
                                    Perusahaan *
                                </label>
                                <select id="company_id" name="company_id" required
                                        class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    <option value="">Pilih Perusahaan</option>
                                    @foreach($companies as $company)
                                        <option value="{{ $company->id }}" {{ old('company_id') == $company->id ? 'selected' : '' }}>
                                            {{ $company->name }} ({{ $company->company_code }})
                                        </option>
                                    @endforeach
                                </select>
                                @error('company_id')
                                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <!-- Employee Information -->
                        <div class="bg-[#F6F6F6] p-4 rounded-none mb-6 border border-[#CBB4B0]">
                            <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Karyawan</h3>
                            
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
                                        Nama Lengkap *
                                    </label>
                                    <input type="text" id="name" name="name" value="{{ old('name') }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('name')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                                        Email *
                                    </label>
                                    <input type="email" id="email" name="email" value="{{ old('email') }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('email')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">
                                        Telepon *
                                    </label>
                                    <input type="text" id="phone" name="phone" value="{{ old('phone') }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('phone')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="birth_date" class="block text-sm font-medium text-gray-700 mb-2">
                                        Tanggal Lahir *
                                    </label>
                                    <input type="date" id="birth_date" name="birth_date" value="{{ old('birth_date') }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('birth_date')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="birth_place" class="block text-sm font-medium text-gray-700 mb-2">
                                        Tempat Lahir *
                                    </label>
                                    <input type="text" id="birth_place" name="birth_place" value="{{ old('birth_place') }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('birth_place')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="gender" class="block text-sm font-medium text-gray-700 mb-2">
                                        Jenis Kelamin *
                                    </label>
                                    <select id="gender" name="gender" required
                                            class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                        <option value="">Pilih Jenis Kelamin</option>
                                        <option value="male" {{ old('gender') == 'male' ? 'selected' : '' }}>Laki-laki</option>
                                        <option value="female" {{ old('gender') == 'female' ? 'selected' : '' }}>Perempuan</option>
                                    </select>
                                    @error('gender')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="position" class="block text-sm font-medium text-gray-700 mb-2">
                                        Posisi *
                                    </label>
                                    <input type="text" id="position" name="position" value="{{ old('position') }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('position')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="department" class="block text-sm font-medium text-gray-700 mb-2">
                                        Departemen *
                                    </label>
                                    <input type="text" id="department" name="department" value="{{ old('department') }}" required
                                           class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('department')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>
                            </div>

                            <div class="mt-6">
                                <label for="address" class="block text-sm font-medium text-gray-700 mb-2">
                                    Alamat *
                                </label>
                                <textarea id="address" name="address" rows="3" required
                                          class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">{{ old('address') }}</textarea>
                                @error('address')
                                    <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <!-- Information Box -->
                        <div class="bg-[#192D50] border border-[#CBB4B0] rounded-none p-4">
                            <h4 class="font-medium text-white mb-2">Informasi Penting:</h4>
                            <ul class="text-sm text-white space-y-1">
                                <li>• Nomor karyawan dan kode akses akan dibuat otomatis</li>
                                <li>• Karyawan akan aktif secara default</li>
                                <li>• Kode akses dapat direset nanti jika diperlukan</li>
                                <li>• Pastikan semua informasi valid</li>
                            </ul>
                        </div>

                        <div class="flex items-center justify-end space-x-4">
                            <a href="{{ route('admin.employees.index') }}" 
                               class="px-4 py-2 border border-[#8B8B8B] rounded-none text-sm font-medium text-[#8B8B8B] hover:bg-[#8B8B8B] hover:text-white transition duration-150">
                                Batal
                            </a>
                            <button type="submit" 
                                    class="px-6 py-2 bg-[#192D50] text-white rounded-none text-sm font-medium hover:bg-[#8B8B8B] transition duration-150">
                                Simpan Karyawan
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
